/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.updates;

import com.ibm.hsc.websm.updates.FirmwareUpdateConstants;
import com.ibm.hsc.websm.updates.OperationCompletedInfo;
import com.ibm.hsc.websm.updates.PIUpdateErrorIds;
import com.ibm.hsc.websm.updates.PIUpdater;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.managed.AlreadyBusyException;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.report.CompletionReport;
import com.ibm.hwmca.fw.report.CompletionReportCode;
import com.ibm.hwmca.fw.task.ProgressReportListenerImpl;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import java.util.List;

public class ChangeIntStartApply
implements FirmwareUpdateConstants,
PIUpdateErrorIds {
    private static final String TRACE_MASKT = "XUPDLAPT";
    private static final String TRACE_MASKF = "XUPDLAPF";
    private static final String TRACE_MASKD = "XUPDLAPD";
    private PIUpdater piUpdater;
    private int activateType;
    private boolean autoCommit;
    private List updateLevels;
    private boolean isSpecificLevels = false;
    private ProgressReportListenerImpl reportListener = null;
    private static FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(2, "ChangeIntStartApply");

    public ChangeIntStartApply(PIUpdater pIUpdater, int n, boolean bl, List list, ProgressReportListenerImpl progressReportListenerImpl) {
        Trace.trace((String)TRACE_MASKD, (Object)" [ChangeIntStartApply constructor]  prepare to start apply thread.");
        this.piUpdater = pIUpdater;
        this.activateType = n;
        this.autoCommit = bl;
        this.updateLevels = list;
        this.reportListener = progressReportListenerImpl;
        this.isSpecificLevels = null != list;
        Trace.trace((String)TRACE_MASKD, (Object)(" [ChangeIntStartApply constructor]  is this specific-levels case: " + this.isSpecificLevels));
        Runnable runnable = new Runnable(){

            public void run() {
                Trace.trace((String)ChangeIntStartApply.TRACE_MASKT, (Object)"-> ChangeIntStartApply.runApply.run()");
                ChangeIntStartApply.this.doApply();
                Trace.trace((String)ChangeIntStartApply.TRACE_MASKT, (Object)"<- ChangeIntStartApply.runApply().run()");
            }
        };
        Thread thread = new Thread(runnable, "ChangeIntStartApply");
        thread.setDaemon(true);
        thread.start();
    }

    private void doApply() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> ChangeIntStartApply.doApply()");
        Trace.trace((String)TRACE_MASKF, (Object)"   ChangeIntStartApply.doApply() - perform the apply");
        try {
            switch (this.activateType) {
                case 1: {
                    Trace.trace((String)TRACE_MASKD, (Object)"   ChangeIntStartApply.doApply() apply concurrent - don't disrupt now, no deferred disruption.");
                    if (this.isSpecificLevels) {
                        this.piUpdater.applyStagedThroughLevel(false, false, this.autoCommit, false, this.updateLevels);
                        break;
                    }
                    this.piUpdater.applyAllStaged(false, false, this.autoCommit);
                    break;
                }
                case 2: {
                    Trace.trace((String)TRACE_MASKD, (Object)"   ChangeIntStartApply.doApply() apply deferred - don't disrupt now, deferred disruption okay.");
                    if (this.isSpecificLevels) {
                        this.piUpdater.applyStagedThroughLevel(false, true, this.autoCommit, false, this.updateLevels);
                        break;
                    }
                    this.piUpdater.applyAllStaged(false, true, this.autoCommit);
                    break;
                }
                default: {
                    Trace.trace((String)TRACE_MASKD, (Object)"   ChangeIntStartApply.doApply() apply disruptive - disruption now okay, no deferred disruption.");
                    if (this.isSpecificLevels) {
                        this.piUpdater.applyStagedThroughLevel(true, false, this.autoCommit, false, this.updateLevels);
                        break;
                    }
                    this.piUpdater.applyAllStaged(true, false, this.autoCommit);
                    break;
                }
            }
        }
        catch (HException hException) {
            Trace.trace((String)TRACE_MASKT, (Object)("   ChangeIntStartApply.doApply() - caught exception: " + (Object)((Object)hException)));
            ObjectId objectId = ((OperationCompletedInfo)this.piUpdater.getAttachment()).getObjectId();
            CompletionReport completionReport = new CompletionReport(objectId);
            completionReport.setCompletionCode(CompletionReportCode.FAIL);
            MessageText messageText = this.piUpdater.getLastMessage();
            if (null == messageText) {
                messageText = new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundle", "PROGRESS_PANEL_ERROR_PROCESSING");
            }
            completionReport.setData((Object)messageText);
            this.reportListener.completeReport(completionReport);
        }
        catch (AlreadyBusyException alreadyBusyException) {
            Trace.trace((String)TRACE_MASKT, (Object)("   ChangeIntStartApply.doApply() - caught exception: " + (Object)((Object)alreadyBusyException)));
            ObjectId objectId = ((OperationCompletedInfo)this.piUpdater.getAttachment()).getObjectId();
            CompletionReport completionReport = new CompletionReport(objectId);
            completionReport.setCompletionCode(CompletionReportCode.FAIL);
            MessageText messageText = this.piUpdater.getLastMessage();
            if (null == messageText) {
                messageText = new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundle", "PROGRESS_PANEL_ERROR_PROCESSING");
            }
            completionReport.setData((Object)messageText);
            this.reportListener.completeReport(completionReport);
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- ChangeIntStartApply.doApply()");
    }
}

